#include <stdio.h>
#include <stdlib.h>

#define MAXN 300000

typedef struct {
    long long x, y;
    int idx;
} Vec;

Vec a[2 * MAXN];
int n;

int half(Vec v) {
    return (v.y > 0 || (v.y == 0 && v.x > 0));
}

long long cross(Vec a, Vec b) {
    return a.x * b.y - a.y * b.x;
}

int cmp(const void *p1, const void *p2) {
    Vec *a = (Vec *)p1;
    Vec *b = (Vec *)p2;
    if (half(*a) != half(*b))
        return half(*b) - half(*a);
    if (cross(*a, *b) > 0) return -1;
    if (cross(*a, *b) < 0) return 1;
    return 0;
}

int main() {
    int i;
    scanf("%d", &n);

    for (i = 0; i < n; i++) {
        scanf("%lld %lld", &a[i].x, &a[i].y);
        a[i].idx = i + 1;
    }

    qsort(a, n, sizeof(Vec), cmp);

    for (i = 0; i < n; i++)
        a[i + n] = a[i];

    {
        long long sx = 0, sy = 0;
        long long best = 0;
        int l = 0, r, bestL = 0, bestR = -1;

        for (r = 0; r < 2 * n; r++) {
            sx += a[r].x;
            sy += a[r].y;

            while (cross(a[l], a[r]) < 0) {
                sx -= a[l].x;
                sy -= a[l].y;
                l++;
            }

            if (sx * sx + sy * sy > best) {
                best = sx * sx + sy * sy;
                bestL = l;
                bestR = r;
            }
        }

        printf("%d\n", bestR - bestL + 1);
        for (i = bestL; i <= bestR; i++)
            printf("%d ", a[i].idx);
        printf("\n");
    }

    return 0;
}